extends Node2D
class_name Bullet_Movement

@export var MOVING_BULLET: Node2D
@export var VELOCIDAD = 100
@export var RANGE = 200
@export var DESTROY_EFFECT: Destroy_Component
@export var DESTROY_OUT_RANGE: bool
var first_point
signal OUT_OF_RANGE
func _ready():
	first_point = MOVING_BULLET.position

func _process(delta):
	var direction = MOVING_BULLET.global_transform.basis_xform(Vector2.RIGHT)
	MOVING_BULLET.position += direction * VELOCIDAD * delta
	if MOVING_BULLET.position.distance_to(first_point) > RANGE:
		if DESTROY_OUT_RANGE:
			DESTROY_EFFECT.Destroy()


