extends Node2D
class_name Destroy_Component

@export var DESTROY_EFFECT: PackedScene
@export var COMPONENT: Node2D
@export var DROP: PackedScene = preload("res://Components/Objects/Recover/Recover.tscn")
@export var PROBABILITY: float = 0.25
signal destroyed

func Destroy():
	emit_signal("destroyed")
	if DESTROY_EFFECT:
		var ef = DESTROY_EFFECT.instantiate()
		ef.position = COMPONENT.global_position
		ef.rotation = COMPONENT.global_rotation
		if ef is GPUParticles2D:
			ef.emitting = true
		get_tree().get_current_scene().call_deferred("add_child", ef)
		if DROP:
			randomize()
			if randf() <= PROBABILITY:
				var e = DROP.instantiate()
				e.position = COMPONENT.global_position
				e.rotation = COMPONENT.global_rotation
				get_tree().get_current_scene().call_deferred("add_child", e)
		COMPONENT.queue_free()
