extends Node

var WIZARD: Physics_Component
@export var Debug: Label
@export var USER: Physics_Component
@export var Estado_Actual: Estado
var Estados: Dictionary = {} 
# Called when the node enters the scene tree for the first time.
func _ready():
	if Debug:
		Debug.text = Estado_Actual.name
	WIZARD = get_tree().get_first_node_in_group("Wizard")
	for c in get_children():
		if c is Estado:
			var m: Estado = c
			c.User = USER
			c.Wizard = WIZARD
			Estados[c.name] = c
			m.Transicion.connect(En_Transicion)

func _process(delta):
	Estado_Actual.Process(delta)

func _physics_process(delta):
	Estado_Actual.Physics_Process(delta)

func En_Transicion(estado_signal, nuevo):
	if estado_signal != Estado_Actual:
		return
	
	var new: Estado = Estados.get(nuevo)
	if !new:
		return
	
	new.Enter()
	Estado_Actual.Exit()
	Estado_Actual = new
	if Debug:
		Debug.text = Estado_Actual.name
