extends Estado

@export var SPEED: float = 100
@export var MAX_RETREATH: float = 1
@export var MAX_RANGE:float = 5
@export var LOOK_PLAYER: bool
@export var MESH: Node2D
var retreath = 0

var direction = Vector2.ZERO
var atacar = true
var ret = true
@export var DETECTION_RANGE: float = 200

func Atacar():
	if is_instance_valid(Wizard) and is_instance_valid(User):
		direction = Wizard.global_position - User.global_position
	
	if direction.length() > DETECTION_RANGE:
		Transicion.emit(self, "Idle")

func Physics_Process(delta):
	if atacar:
		ret = true
		Atacar()
		if LOOK_PLAYER:
			if MESH:
				if is_instance_valid(Wizard):
					MESH.look_at(Wizard.global_position)
	else:
		Retraer(delta)
		if LOOK_PLAYER:
			if MESH:
				MESH.look_at(direction)
	if is_instance_valid(User):
		User.velocity = direction.normalized() * SPEED
	

func Retraer(delta):
	if ret:
		ret = false
		direction = Vector2(randf_range(-MAX_RANGE,MAX_RANGE),(randf_range(-MAX_RANGE,MAX_RANGE))).normalized()
		retreath = randf_range(0,MAX_RETREATH)
	if retreath > 0:
		retreath -= delta
	else:
		atacar = true

func _on_hitbox_ataco():
	atacar = false


func _on_hitbox_dañado():
	atacar = true


