extends Estado

@export var SPEED: float = 100

var direction = Vector2.ZERO
@export var MAX_WANDER: float = 1
@export var MAX_RANGE:float = 1
@export var DETECTION_RANGE: Vector2 = Vector2(50,50)
var wander = 0

func RandomW():
	direction = Vector2(randf_range(-MAX_RANGE,MAX_RANGE),(randf_range(-MAX_RANGE,MAX_RANGE))).normalized()
	wander = randf_range(0,MAX_WANDER)

func Process(delta):
	if wander > 0:
		wander -= delta
	else:
		RandomW()
	
	if is_instance_valid(Wizard) and is_instance_valid(User):
		if Wizard.global_position - User.global_position < DETECTION_RANGE:
			Transicion.emit(self, "Atacando")
	

func Physics_Process(delta):
	User.velocity = direction * SPEED



func _on_hitbox_dañado():
	Transicion.emit(self, "Atacando")

