extends Area2D
class_name Hitbox
signal Dañado
signal Ataco
@export var Physics: Physics_Component
@export var Gang: Wizard_Component
@export var Damage_On_Touch: bool
@export var DMG_Touch: float
@export var Destroy_on_touch: bool
@export var Destroy_on_wall: bool
@export var Destroy_Effect: Destroy_Component
@export var Heal: Vector2 = Vector2.ZERO
@export var Objective: String = "EnemyHitbox"
var Hitbox_Hitting: Hitbox

func Damage_Hitbox(dmg: float):
	if Gang:
		Gang.Damage_user(dmg)
		Dañado.emit()

func Set_Mana(mana: float):
	if Gang:
		Gang.Change_Mana(mana)

func _process(delta):
	if Hitbox_Hitting != null:
		if Hitbox_Hitting.Gang:
			if Hitbox_Hitting.Gang.Invencible == false:
				if Damage_On_Touch:
					Hitbox_Hitting.Damage_Hitbox(DMG_Touch)
					Hitbox_Hitting.Dañado.emit()
					Hitbox_Hitting.Gang.LastHit = get_tree().get_first_node_in_group("WizardHitbox")
					Ataco.emit()
				if Heal != Vector2.ZERO:
					Hitbox_Hitting.Gang.Add_Health(Heal.x)
					Hitbox_Hitting.Gang.Change_Mana(Heal.y)
				if Destroy_on_touch:
					Destroy_Effect.Destroy()
				

func _on_area_entered(area):
	if area is Hitbox:
		if Objective:
			if area.is_in_group(Objective):
				Hitbox_Hitting = area
		else:
			Hitbox_Hitting = area


func _on_body_entered(body):
	if Destroy_on_wall and not body is Knockback:
		Destroy_Effect.Destroy()


func _on_area_exited(area):
	if Hitbox_Hitting != null:
		if area is Hitbox and area == Hitbox_Hitting:
			Hitbox_Hitting = null
