extends Area2D
class_name Knockback

@export var KNOCKBACK: float = 100
@export var DEATH_TIME: float = 0.1
@export var DAMAGE: float = 0
@export var USER: Node2D
@export var EXEPTION: String
@export var TRANSPORT = false

var transporteds: Array

func _ready():
	if DEATH_TIME != 0:
		$Timer.wait_time = DEATH_TIME
		$Timer.start()
		await $Timer.timeout
		if USER:
			USER.queue_free()

func _process(delta):
	if TRANSPORT:
		if transporteds.size() > 0:
			for c in transporteds:
				c.position = lerp(c.position, global_position,0.1)

func _on_area_entered(area):
	if area is Hitbox :
		if EXEPTION:
			if area.get_parent().is_in_group(EXEPTION):
				return
		var h: Physics_Component = area.Physics
		if h:
			if h.AFFECTED_BY_KNOCKBACK:
				if TRANSPORT:
					transporteds.push_back(h)
				h.velocity = Vector2.ZERO
				var d = global_position.direction_to(h.global_position) * KNOCKBACK
				h.knockback = d
				if DAMAGE != 0:
					var health: Wizard_Component = area.Gang
					if health:
						health.Damage_user(DAMAGE)
				if USER:
					USER.queue_free()
