extends Node2D
class_name Magic_Component

@export var WIZARD_CMP: Wizard_Component
var HABILIDADES: Habilidades
var Hability_Tree
@export var Basic_Tree: Array[Spell]
@export var VariantOne_Tree: Array[Spell]
@export var VariantTwo_Tree: Array[Spell]
var Gen:int
@export var SPELLS: Array[Spell]
@export var Player_Controlled = true
@export var Player: Physics_Component
var current_spell = 0
var current_delay = 0

func _ready():
	randomize()
	Gen = randi_range(0,1)
	if Player_Controlled:
		Hability_Tree = get_tree().get_first_node_in_group("Arbol")
		HABILIDADES = get_tree().get_first_node_in_group("Habilidades")

var disparable = true
func IA_Shoot():
	var f = SPELLS[current_spell].EFECTO
	add_child(f.instantiate())
	if SPELLS[current_spell].DELAY > 0 and disparable:
		print("Disaprando")
		disparable = false
		$Timer.wait_time = SPELLS[current_spell].CHARGE
		$Timer.start()
		await $Timer.timeout
		disparable = true
		for n in get_children():
			if not n is Timer:
				n.queue_free()
		var s = SPELLS[current_spell].ECENA
		var sta = s.instantiate()
		sta.position = global_position
		sta.rotation = global_rotation
		get_tree().get_current_scene().add_child(sta)

func _process(delta):
	if Player_Controlled:
		
		var f = SPELLS[current_spell].EFECTO
		if Input.is_action_just_pressed("disparar"):
			add_child(f.instantiate())
			if SPELLS[current_spell].DELAY > 0:
				var dif = WIZARD_CMP.RANGO * (SPELLS[current_spell].CHARGE / 20)
				current_delay = (SPELLS[current_spell].CHARGE - dif)
		if Input.is_action_pressed("disparar"):
			if current_delay > 0:
				current_delay -= delta
			else:
				for n in get_children():
					n.queue_free()
				if SPELLS[current_spell].COSTE < WIZARD_CMP.MANA:
					WIZARD_CMP.Change_Mana(-SPELLS[current_spell].COSTE)
					var s = SPELLS[current_spell].ECENA
					var sta = s.instantiate()
					sta.position = global_position
					sta.rotation = global_rotation
					get_tree().get_current_scene().add_child(sta)
					var dif = WIZARD_CMP.RANGO * (SPELLS[current_spell].CHARGE / 20)
					current_delay = (SPELLS[current_spell].CHARGE - dif) + SPELLS[current_spell].DELAY 
					add_child(f.instantiate())
		elif current_delay > 0:
			current_delay = 0
			for n in get_children():
					n.queue_free()
	
		if Input.is_action_just_pressed("habilidades") and current_delay == 0:
			HABILIDADES.show()
		elif Input.is_action_just_released("habilidades"):
			HABILIDADES.hide()

func _input(event):
	if Player_Controlled:
		if Input.is_action_just_pressed("ArbolNatural"):
			Hability_Tree.Hechizos = Basic_Tree
			Hability_Tree.Hechisero = Player
			Hability_Tree.start()
			if Hability_Tree.visible:
				Hability_Tree.hide()
			else:
				Hability_Tree.show()
		if Input.is_action_just_pressed("ArbolGenetico"):
			Hability_Tree.Hechisero = Player
			if Gen == 0:
				Hability_Tree.Hechizos = VariantOne_Tree
			elif  Gen == 1:
				Hability_Tree.Hechizos = VariantTwo_Tree
			Hability_Tree.start()
			if Hability_Tree.visible:
				Hability_Tree.hide()
			else:
				Hability_Tree.show()
		if event is InputEventKey:
			if event.unicode in range(48,58):
				if int(char(event.unicode)) - 1 < SPELLS.size():
					if current_delay == 0:
						current_spell = int(char(event.unicode)) - 1
