extends CharacterBody2D
class_name Physics_Component

@export var PLAYER_CONTROLLED = false
@export var AFFECTED_BY_GRAVITY = true
@export var AFFECTED_BY_KNOCKBACK = true
@export var SPEED = 125.0
@export var JUMP_VELOCITY = -300.0
@export var sprite: AnimatedSprite2D
var gravity = ProjectSettings.get_setting("physics/2d/default_gravity")
var knockback = Vector2.ZERO

func _physics_process(delta):
	if not is_on_floor() and AFFECTED_BY_GRAVITY:
		velocity.y += gravity * delta
	if PLAYER_CONTROLLED:
		if Input.is_action_just_pressed("saltar") and is_on_floor():
			velocity.y = JUMP_VELOCITY
		var direction = Input.get_axis("izquierda", "derecha")
		if direction:
			velocity.x = direction * SPEED
		else:
			velocity.x = move_toward(velocity.x, 0, SPEED)
	if sprite:
		if Input.get_axis("izquierda", "derecha") < 0 and not sprite.flip_h:
			sprite.flip_h = true
		elif Input.get_axis("izquierda", "derecha") > 0 and sprite.flip_h:
			sprite.flip_h = false
		if Input.get_axis("izquierda", "derecha") != 0:
			sprite.play("walk")
		else:
			sprite.play("idle")
	if Input.is_action_just_pressed("Pausa"):
		get_tree().get_first_node_in_group("Pausa").show()
	velocity += Vector2(knockback.x, knockback.y / 4)
	move_and_slide()
	knockback = lerp(knockback,Vector2.ZERO,0.1)

func Left():
	velocity.x = -SPEED

func right():
	velocity.x = SPEED

func up():
	velocity.y = -JUMP_VELOCITY

func down():
	velocity.y = JUMP_VELOCITY

